import argparse

from devicepilot.bootstrap.bootstraper import BootstrapBase

from hw_abstraction.hal import HAL


class Bootstrap(BootstrapBase):

    def __init__(self):
        parser = argparse.ArgumentParser(description='Device control application based on the Device Pilot')
        parser.add_argument(
            '-ts', '--teststage',
            help=f"Override the test stage setting in the HAL config. The .cfg/.adj files remain unchanged.",
            type=str, default='', required=False,
        )
        super().__init__(parser)

    def setup(self):
        hal = HAL(self.parsed_arguments.teststage)
        self.register_hal(hal)
